﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// Listing 3-20. Nazwane opcje utworzone przy użyciu stałych typu int
// Uwaga: to nie jest doskonały przykład - ma on na celu zilustrowanie
//  dlaczego język C# udostępnia typy wyliczeniowe, stanowiące lepsze rozwiązanie
//  prezentowanego problemu. (czyli, przykład pokazuje czego NIE należy robić!)
class Plane
{
    public const int Approaching = 0;
    public const int Leaving = 1;

    public Plane(string newIdentifier)
    {
        _identifier = newIdentifier;
    }

    public string Identifier
    {
        get { return _identifier; }
    }
    private readonly string _identifier;

    const double kilometersPerMile = 1.609344;

    public double SpeedInMilesPerHour
    {
        get
        {
            return SpeedInKilometersPerHour / kilometersPerMile;
        }
        set
        {
            // Pole tylko do odczytu niemożliwia nam napisanie instrukcji
            // o następującej postaci:
            //
            //  _identifier += ": prędkość zmodyfikowano do " + value;
            //
            // a zatem "chytry" programista musi teraz napisać
            // kod debugujący, który nie może modyfikować wartości 
            // właściwości:
            Console.WriteLine(Identifier + ": prędkość zmodyfikowano do " + value);
            SpeedInKilometersPerHour = value * kilometersPerMile;
        }
    }

    public double SpeedInKilometersPerHour
    {
        get;
        set;
    }

    public int Direction { get; set; }
}